package demo.applet;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JApplet;
import javax.swing.Timer;

import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class Applet1 extends JApplet {
	class DataGenerator extends Timer implements ActionListener {

		public void actionPerformed(ActionEvent actionevent) {
			long l = Runtime.getRuntime().freeMemory();
			long l1 = Runtime.getRuntime().totalMemory();
			addTotalObservation(l1);
			addFreeObservation(l);
		}

		DataGenerator() {
			super(1000, null);
			addActionListener(this);
		}
	}

	public Applet1() {
		total = new TimeSeries("Total", org.jfree.data.time.Millisecond.class);
		total.setMaximumItemAge(30000L);
		free = new TimeSeries("Free", org.jfree.data.time.Millisecond.class);
		free.setMaximumItemAge(30000L);
		TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
		timeseriescollection.addSeries(total);
		timeseriescollection.addSeries(free);
		DateAxis dateaxis = new DateAxis("Time");
		NumberAxis numberaxis = new NumberAxis("Memory");
		XYLineAndShapeRenderer xylineandshaperenderer = new XYLineAndShapeRenderer(
				true, false);
		XYPlot xyplot = new XYPlot(timeseriescollection, dateaxis, numberaxis,
				xylineandshaperenderer);
		xyplot.setBackgroundPaint(Color.lightGray);
		xyplot.setDomainGridlinePaint(Color.white);
		xyplot.setRangeGridlinePaint(Color.white);
		xylineandshaperenderer.setSeriesPaint(0, Color.red);
		xylineandshaperenderer.setSeriesPaint(1, Color.green);
		xylineandshaperenderer.setSeriesStroke(0, new BasicStroke(1.5F));
		xylineandshaperenderer.setSeriesStroke(1, new BasicStroke(1.5F));
		dateaxis.setAutoRange(true);
		dateaxis.setLowerMargin(0.0D);
		dateaxis.setUpperMargin(0.0D);
		dateaxis.setTickLabelsVisible(true);
		numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
		JFreeChart jfreechart = new JFreeChart("Memory Usage",
				JFreeChart.DEFAULT_TITLE_FONT, xyplot, true);
		jfreechart.setBackgroundPaint(Color.white);
		ChartPanel chartpanel = new ChartPanel(jfreechart);
		chartpanel.setPopupMenu(null);
		getContentPane().add(chartpanel);
		(new DataGenerator()).start();
	}

	private void addTotalObservation(double d) {
		total.add(new Millisecond(), d);
	}

	private void addFreeObservation(double d) {
		free.add(new Millisecond(), d);
	}

	private TimeSeries total;
	private TimeSeries free;

}
